﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace SampleApp
{

    [Serializable]
    public class ApiException : Exception
    {
        private const string DefaultMessage = "Failed to process API request.";

        public ApiException()
            : base(DefaultMessage)
        {
        }

        public ApiException(string message)
            : base(GetMessage(message))
        {
        }

        public ApiException(string message, Exception innerException)
            : base(GetMessage(message), innerException)
        {
        }

        protected ApiException(SerializationInfo info, StreamingContext context)
           : base(info, context)
        {
        }

        private static string GetMessage(string message)
        {
            return string.IsNullOrEmpty(message)
                ? DefaultMessage
                : message;
        }
    }
}
