﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SampleApp.Services;

namespace SampleApp.Controls
{
    public partial class TimekeeperInput : UserControl
    {
        private ILog logger;
        private DataObjectService objectService;

        public TimekeeperInput(ILog logger, DataObjectService objectService)
        {
            this.logger = logger;
            this.objectService = objectService;

            InitializeComponent();
        }

        public void SetTimekeeperTemplate(string template) => tTimekeeper.Text = template;

        public void SetPersonTemplate(string template) => tPerson.Text = template;

        public bool TryGetParameters(out TimekeeperParameters parameters)
        {
            parameters = new TimekeeperParameters();

            if (!int.TryParse(tNumToCreate.Text, out var numToCreate) || numToCreate <= 0)
            {
                logger.Log("Number to create must be a valid integer greater than zero.");
                return false;
            }

            if (!int.TryParse(tSuffix.Text, out var suffix) || suffix < 0)
            {
                logger.Log("Suffix must be a valid integer padded with zeroes. e.g. 00001");
                return false;
            }

            parameters.NumToCreate = numToCreate;
            parameters.SuffixStart = suffix;
            parameters.SuffixFormat = "D" + tSuffix.Text.Length;
            parameters.Timekeeper = objectService.Parse(tTimekeeper.Text);

            if (cbGeneratePerson.Checked)
            {
                parameters.GeneratePerson = true;
                parameters.Person = objectService.Parse(tPerson.Text);
            }

            return true;
        }
    }
}
