﻿namespace SampleApp.Services
{
    using System;
    using System.Configuration;

    /// <summary>
    /// Service to provided an apllication configuration properties.
    /// </summary>
    public class ConfigurationService
    {
        private AppSettings appSettings;
        private CiamSettings ciamSettings;

        public virtual AppSettings GetAppSettings()
        {
            if (appSettings == null)
            {
                appSettings = new AppSettings();
                appSettings.Url = GetUrl();
                appSettings.AuthenticationMode = GetAuthenticationMode();
            }

            return appSettings;
        }

        public virtual CiamSettings GetCiamSettings()
        {
            if (ciamSettings == null)
            {
                ciamSettings = new CiamSettings();
                ciamSettings.Audience = GetAudience();
                ciamSettings.Authority = GetOption("ciam:authority");
                ciamSettings.ClientId = GetOption("ciam:clientId");
                ciamSettings.Scope = GetOption("ciam:scope");
                ciamSettings.Connection = GetOption("ciam:connection");
                ciamSettings.LoginHint = GetOption("ciam:loginHint");
                ciamSettings.ReplyPath = GetOption("ciam:replyPath");
                ciamSettings.ReplyPort = GetReplyPort();
            }

            return ciamSettings;
        }

        protected virtual string GetOption(string option) => ConfigurationManager.AppSettings[option];

        protected virtual string GetAudience() => GetOption("ciam:audience");

        protected virtual int GetReplyPort() => Int32.Parse(GetOption("ciam:replyPort"));

        protected virtual string GetUrl() => GetOption("api:url");

        protected virtual AuthenticationMode GetAuthenticationMode()
        {
            var authMode = GetOption("auth:mode").ToLower();

            if (authMode == "windows")
            {
                return AuthenticationMode.Windows;
            }

            if (authMode == "ciam")
            {
                return AuthenticationMode.CIAM;
            }

            throw new NotImplementedException($"{authMode} is not supported");
        }
    }
}
