﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;

    public class ChargeCardPendingView : CaseBaseView
    {
        ChargeCardPendingInput input;

        public ChargeCardPendingView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Charge Index");
            this.input = new ChargeCardPendingInput(this, this.objectService, this.cacheService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "ChargeCardPending";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.ChargeCardPending);
            input.SetChargeCardTemplate(template);
        }

        protected async override Task Lookup(string index)
        {
            if (!int.TryParse(index, out var chargePendIndex) || chargePendIndex <= 0)
            {
                Log("Please enter a valid Charge Index to copy from.");
                return;
            }

            var chargecardpending = await apiService.GetChargecardPending(chargePendIndex);
            var model = Clone(chargecardpending);
            var template = templateService.GetTemplate(TemplateId.ChargeCardPending, model);
            input.SetChargeCardTemplate(template);
        }

        /// <summary>
        /// Generates ChargeCard list.
        /// </summary>
        protected override async Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var chargecards = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);
                var matterIndex = 0;

                for (var i = 0; i < chargecards.Length; i++)
                {
                    var date = parameters.StartDate.AddDays(i / parameters.ChargeCardPerDay).ToString("yyyy-MM-dd");
                    chargecards[i] = Generate(parameters.ChargeCardPending, CreateFormatter(suffix.Increment(), date));

                    if (parameters.Matters != null)
                    {
                        Set(chargecards[i], "Matter", parameters.Matters[matterIndex++]);
                        matterIndex %= parameters.Matters.Count;
                    }
                }

                await apiService.Create<DTO.ChargeCardCreateResponse>(
                apiService.CreateGenericDataRequest("dataobject", chargecards, chargecards[0].SubclassId, "ChrgCardPending"));

                Log($"Total {parameters.NumToCreate} ChargeCardPending(s) successfully created.");
            }
        }
    }
}
