﻿namespace SampleApp.Views
{
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;
    using System.Threading.Tasks;

    public class EntityOrgView : CaseBaseView
    {
        private EntityOrgInput input;

        public EntityOrgView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Entity Index");
            this.input = new EntityOrgInput(this, this.objectService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "EntityOrg";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.EntityOrganization);
            input.SetOrganizationTemplate(template);
        }

        protected override async Task Lookup(string index)
        {
            if (!int.TryParse(index, out var orgIndex))
            {
                Log("Please enter a valid Entity Index to copy from.");
                return;
            }

            var organization = await apiService.GetEntityOrg(orgIndex);
            var model = Clone(organization.AsObjectLite());
            var template = templateService.GetTemplate(TemplateId.EntityOrganization, model);
            input.SetOrganizationTemplate(template);
        }

        /// <summary>
        /// Generates Entity Organization list.
        /// </summary>
        protected async override Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var organizations = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);

                for (var i = 0; i < organizations.Length; i++)
                {
                    organizations[i] = Generate(parameters.Organization, CreateFormatter(suffix.Increment()));
                }

                await apiService.Create<DTO.EntityCreateResponse>(
                    apiService.CreateDataRequest<DTO.EntityCreateRequest>("entity/organization", organizations));

                Log($"Total {parameters.NumToCreate} Organization(s) successfully created.");
            }
        }
    }
}
