﻿namespace SampleApp.Services
{
    using System;

    /// <summary>
    /// Configuration Service extention to override specific configuration properties.
    /// </summary>
    public class ConfigurationServiceEx : ConfigurationService
    {
        private string url;
        private DTO.ServerInfo info;

        public ConfigurationServiceEx(string url, DTO.ServerInfo info)
        {
            if (url == null) throw new ArgumentNullException(nameof(url));
            if (info == null) throw new ArgumentNullException(nameof(info));

            this.url = url;
            this.info = info;
        }


        protected override string GetUrl()
        {
            return url;
        }

        protected override AuthenticationMode GetAuthenticationMode()
        {
            if (info.Hosting.AuthenticationType == DTO.AuthenticationType._0)
            {
                return AuthenticationMode.Windows;
            }
            else if (info.Hosting.AuthenticationType == DTO.AuthenticationType._2)
            {
                return AuthenticationMode.CIAM;
            }

            throw new NotImplementedException("Azure authentication is not supported");
        }

        protected override string GetAudience()
        {
            return info.WebApplication.Ciam?.Audience;
        }
    }
}
