﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SampleApp.Services;

namespace SampleApp.Controls
{
    public partial class VoucherInput : UserControl
    {
        private ILog logger;
        private DataObjectService objectService;
        private CacheService cacheService;

        public VoucherInput(ILog logger, DataObjectService objectService, CacheService cacheService)
        {
            this.logger = logger;
            this.objectService = objectService;
            this.cacheService = cacheService;

            InitializeComponent();
            tStartDate.Text = DateTime.Now.ToShortDateString();
        }

        public void SetTimecardTemplate(string template) => tVoucher.Text = template;

        public bool TryGetParameters(out VoucherParameters parameters)
        {
            parameters = new VoucherParameters();

            if (!int.TryParse(tNumToCreate.Text, out var numToCreate) || numToCreate <= 0)
            {
                logger.Log("Number to create must be a valid integer greater than zero.");
                return false;
            }

            if (!int.TryParse(tSuffix.Text, out var suffix) || suffix < 0)
            {
                logger.Log("Suffix must be a valid integer padded with zeroes. e.g. 00001");
                return false;
            }

            if (!int.TryParse(tVoucherPerDay.Text, out var perDay) || perDay <= 0)
            {
                logger.Log("Voucher per day must be a valid integer greater than zero.");
                return false;
            }

            if (!DateTime.TryParse(tStartDate.Text, out var startDate))
            {
                logger.Log("Start Date must be a valid date time.");
                return false;
            }

            parameters.NumToCreate = numToCreate;
            parameters.SuffixStart = suffix;
            parameters.SuffixFormat = "D" + tSuffix.Text.Length;
            parameters.StartDate = startDate;
            parameters.VoucherPerDay = perDay;
            parameters.Voucher = objectService.Parse(tVoucher.Text);

            return true;
        }
    }
}
