﻿using System.Collections.Generic;

namespace SampleApp.DTO
{
    /// <summary>
    /// Data Object model.
    /// </summary>
    public interface IDataObjectModel
    {
        /// <summary>
        /// Gets or sets the DataCollection.
        /// </summary>
        DataObjectLiteCollection DataCollection { get; set; }
    }

    /// <summary>
    /// Response to a request that returns a boolean success/fail.
    /// </summary>
    public interface ISuccess
    {
        /// <summary>
        /// Gets or sets a value indicating whether a request was successful.
        /// </summary>
        bool Success { get; set; }

        /// <summary>
        /// Gets or sets an error message.
        /// </summary>
        string Message { get; set; }
    }

    /// <summary>
    /// Response to a data request that returns a success/fail status along with the data collection.
    /// </summary>
    public interface ISuccessModel : IDataObjectModel, ISuccess
    {
    }

    // Code below extends standard generated entities to common interfaces
    // to have an ability to process them into generic way. 

    public partial class MatterGetResponse : ISuccess
    {
    }

    public partial class ClientGetResponse : ISuccess
    {
    }

    public partial class EntityGetResponse : ISuccess
    {
    }

    public partial class TimekeeperGetResponse : ISuccess
    {
    }

    public partial class TimecardGetResponse : ISuccess
    {
    }

    public partial class TimecardPendingGetResponse : ISuccess
    {
    }

    public partial class VoucherGetResponse : ISuccess
    {
    }

    public partial class CostCardGetResponse : ISuccess
    {
    }

    public partial class CostCardPendingGetResponse : ISuccess
    {
    }

    public partial class ClientTemplateResponse : ISuccessModel
    {
    }

    public partial class MatterTemplateResponse : ISuccessModel
    {
    }

    public partial class EntityTemplateResponse : ISuccessModel
    {
    }

    public partial class TimekeeperTemplateResponse : ISuccessModel
    {
    }

    public partial class MatterCreateRequest : IDataObjectModel
    {
    }

    public partial class MatterCreateResponse : ISuccessModel
    {
    }

    public partial class ClientCreateRequest : IDataObjectModel
    {
    }

    public partial class ClientCreateResponse : ISuccessModel
    {
    }

    public partial class EntityCreateRequest : IDataObjectModel
    {
    }

    public partial class EntityCreateResponse : ISuccessModel
    {
    }

    public partial class TimekeeperCreateRequest : IDataObjectModel
    {
    }

    public partial class TimekeeperCreateResponse : ISuccessModel
    {
    }

    public partial class TimecardCreateRequest : IDataObjectModel
    {
    }

    public partial class TimecardCreateResponse : ISuccessModel
    {
    }

    public partial class VoucherCreateResponse : ISuccessModel
    {
    }

    public partial class CostCardCreateRequest : IDataObjectModel
    {
    }

    public partial class CostCardCreateResponse : ISuccessModel
    {
    }

    public partial class ChargeCardGetResponse : ISuccess
    {
    }

    public partial class VendorPayeeGetResponse : ISuccess
    {
    }

    public partial class VendorPayeeCreateResponse : ISuccessModel
    {
    }
    public partial class ChargeCardCreateResponse : ISuccessModel
    {
    }

    public partial class PayeeGetResponse : ISuccess
    {
    }

    public partial class PayeeCreateResponse : ISuccessModel
    {
    }

    public partial class DirectCheckGetResponse : ISuccess
    {
    }

    public partial class DirectCheckCreateResponse : ISuccessModel
    {
    }

    public partial class Attribute
    {
        public Attribute()
        {
            // AccessType = 1 (Enabled) is a default value defined by the API.
            // So during serialization it's skipped and missing from the response.
            // Have to set in constructor explicitly, otherwise it will be restored as 0 (Required) autmatically.
            this.AccessType = AccessType._1;
        }
    }

    // Matter | Client | ... special entities are generated with no inheritance information.
    // AsObjectLite() creates a standard DataObjectLite wrapper on common properties
    // so it can be handled uniformly.

    public partial class Matter
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class Client
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class Timekeeper
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class Entity
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class Timecard
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class CostCard
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class CostCardPending
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }

    public partial class TimecardPending
    {
        public DataObjectLite AsObjectLite()
        {
            return new DataObjectLite
            {
                Id = this.Id,
                Attributes = this.Attributes,
                ChildObjects = this.ChildObjects,
                Error = this.Error,
                SubclassId = this.SubclassId,
            };
        }
    }
}
