﻿namespace SampleApp.Services
{
    using System;
    using System.Collections.Generic;
    using System.Collections.Concurrent;
    using System.Threading.Tasks;

    public class CacheService
    {
        private const int BatchSize = 15;
        private const string MattersKey = "Matters";

        private static ConcurrentDictionary<string, IList<string>> cache = new ConcurrentDictionary<string, IList<string>>();

        private readonly ApiService apiService;
        private readonly ILog logger;
        private readonly DataObjectService objectService;

        public IList<string> Matters => cache.TryGetValue(MattersKey, out var list) ? list : null;

        public CacheService(ApiService apiService, ILog logger)
        {
            this.apiService = apiService;
            this.logger = logger;
            this.objectService = new DataObjectService();
        }

        public async Task CacheMatters(IList<DTO.DataObjectLite> matters)
        {
            if (matters.Count > 0)
            {
                logger.Log("Resolving matters indexes...");

                var indexes = new List<string>(matters.Count);

                for (int i = 0; i < matters.Count; i += BatchSize)
                {
                    foreach (var matter in await apiService.GetMattersByIDs(
                        objectService.GetIds(matters, i, Math.Min(BatchSize, matters.Count - i))))
                    {
                        indexes.Add(objectService.Get(matter.AsObjectLite(), "MattIndex"));
                    }
                }

                cache.AddOrUpdate(MattersKey, indexes, (key, value) => indexes);
            }
        }
    }
}
