﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;

    public class TimecardPendingView : CaseBaseView
    {
        TimecardPendingInput input;

        public TimecardPendingView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Time Index");
            this.input = new TimecardPendingInput(this, this.objectService, this.cacheService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "TimeCardPending";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.TimeCardPending);
            input.SetTimecardTemplate(template);
        }

        protected async override Task Lookup(string index)
        {
            if (!int.TryParse(index, out var timeIndex) || timeIndex <= 0)
            {
                Log("Please enter a valid Time Index to copy from.");
                return;
            }

            var timecard = await apiService.GetTimecardPending(timeIndex);
            var model = Clone(timecard.AsObjectLite());
            var template = templateService.GetTemplate(TemplateId.TimeCardPending, model);
            input.SetTimecardTemplate(template);
        }

        /// <summary>
        /// Generates Timecard list.
        /// </summary>
        protected override async Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var timecards = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);
                var matterIndex = 0;

                for (var i = 0; i < timecards.Length; i++)
                {
                    var date = parameters.StartDate.AddDays(i / parameters.TimecardsPerDay).ToString("yyyy-MM-dd");
                    timecards[i] = Generate(parameters.TimecardPending, CreateFormatter(suffix.Increment(), date));

                    if (parameters.Matters != null)
                    {
                        Set(timecards[i], "Matter", parameters.Matters[matterIndex++]);
                        matterIndex %= parameters.Matters.Count;
                    }
                }

                await apiService.Create<DTO.TimecardCreateResponse>(
                    apiService.CreateDataRequest<DTO.TimecardCreateRequest>("time/pending", timecards));

                Log($"Total {parameters.NumToCreate} Timecard(s) successfully created.");
            }
        }
    }
}
