﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SampleApp.Services;

namespace SampleApp.Controls
{
    public partial class EntityOrgInput : UserControl
    {
        private ILog logger;
        private DataObjectService objectService;

        public EntityOrgInput(ILog logger, DataObjectService objectService)
        {
            this.logger = logger;
            this.objectService = objectService;

            InitializeComponent();
        }

        public void SetOrganizationTemplate(string template) => tOrg.Text = template;

        public bool TryGetParameters(out EntityOrgParameters parameters)
        {
            parameters = new EntityOrgParameters();

            if (!int.TryParse(tNumToCreate.Text, out var numToCreate) || numToCreate <= 0)
            {
                logger.Log("Number to create must be a valid integer greater than zero.");
                return false;
            }

            if (!int.TryParse(tSuffix.Text, out var suffix) || suffix < 0)
            {
                logger.Log("Suffix must be a valid integer padded with zeroes. e.g. 00001");
                return false;
            }

            parameters.NumToCreate = numToCreate;
            parameters.SuffixStart = suffix;
            parameters.SuffixFormat = "D" + tSuffix.Text.Length;
            parameters.Organization = objectService.Parse(tOrg.Text);

            return true;
        }
    }
}
