﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;

    public class VendorPayeeView : CaseBaseView
    {
        VendorPayeeInput input;

        public VendorPayeeView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Vendor Index");
            this.input = new VendorPayeeInput(this, this.objectService, this.cacheService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "VendorPayee";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.NewVendorPayee);
            input.SetVendorPayeeTemplate(template);
        }

        protected async override Task Lookup(string index)
        {
            if (!int.TryParse(index, out var VendorPayeeIndex) || VendorPayeeIndex <= 0)
            {
                Log("Please enter a valid VendorIndex to copy from.");
                return;
            }

            var VendorPayee = await apiService.GetVendorPayee(VendorPayeeIndex);
            var model = Clone(VendorPayee);
            var template = templateService.GetTemplate(TemplateId.NewVendorPayee, model);
            input.SetVendorPayeeTemplate(template);
        }

        /// <summary>
        /// Generates ChargeCard list.
        /// </summary>
        protected override async Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var vendorpayee = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);

                for (var i = 0; i < vendorpayee.Length; i++)
                {
                    var date = parameters.StartDate.AddDays(i / parameters.VendorPayeePerDay).ToString("yyyy-MM-dd");
                    vendorpayee[i] = Generate(parameters.VendorPayee, CreateFormatter(suffix.Increment(), date));
                }

                await apiService.Create<DTO.VendorPayeeCreateResponse>(
                apiService.CreateGenericDataRequest("dataobject", vendorpayee, "NewVendorPayee", "NewVendorPayee"));

                Log($"Total {parameters.NumToCreate} NewVendorPayee(s) successfully created.");
            }
        }
    }
}
