﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace SampleApp
{
    [Serializable]
    public class ApiDataException : ApiException
    {
        public ApiDataException()
            : base()
        {
        }

        public ApiDataException(string message)
            : base(message)
        {
        }

        public ApiDataException(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        protected ApiDataException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
            this.DataCollection = (DTO.DataObjectLiteCollection)info.GetValue("DataCollection", typeof(DTO.DataObjectLiteCollection));
        }

        public DTO.DataObjectLiteCollection DataCollection { get; set; }

        public override void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            base.GetObjectData(info, context);
            info.AddValue("DataCollection", this.DataCollection, typeof(DTO.DataObjectLiteCollection));
        }
    }
}
