﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SampleApp.Services;

namespace SampleApp.Controls
{
    public partial class MatterInput : UserControl
    {
        private ILog logger;
        private DataObjectService objectService;

        public MatterInput(ILog logger, DataObjectService objectService)
        {
            this.logger = logger;
            this.objectService = objectService;

            InitializeComponent();
        }

        public void SetMatterTemplate(string template) => tMatter.Text = template;

        public void SetClientTemplate(string template) => tClient.Text = template;

        public void SetEntityTemplate(string template) => tEntity.Text = template;

        public bool TryGetParameters(out MatterParameters parameters)
        {
            parameters = new MatterParameters();

            if (!int.TryParse(tNumToCreate.Text, out var numToCreate) || numToCreate <= 0)
            {
                logger.Log("Number to create must be a valid integer greater than zero.");
                return false;
            }

            if (!int.TryParse(tSuffix.Text, out var suffix) || suffix < 0)
            {
                logger.Log("Suffix must be a valid integer padded with zeroes. e.g. 00001");
                return false;
            }

            parameters.NumToCreate = numToCreate;
            parameters.SuffixStart = suffix;
            parameters.SuffixFormat = "D" + tSuffix.Text.Length;
            parameters.Matter = objectService.Parse(tMatter.Text);

            if (cbGenerateClient.Checked)
            {
                if (!int.TryParse(tMattersPerClient.Text, out var mattersPerClient) || mattersPerClient <= 0)
                {
                    logger.Log("Matters per client must be a valid integer greater than zero.");
                    return false;
                }

                parameters.MattersPerClient = mattersPerClient;
                parameters.GenerateClient = true;
                parameters.Client = objectService.Parse(tClient.Text);
            }

            if (cbGenerateEntity.Checked)
            {
                parameters.GenerateEntity = true;
                parameters.Entity = objectService.Parse(tEntity.Text);
            }

            return true;
        }
    }
}
