﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;

    public class EntityPersonView : CaseBaseView
    {
        private EntityPersonInput input;

        public EntityPersonView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Entity Index");
            this.input = new EntityPersonInput(this, this.objectService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "EntityPerson";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.EntityPerson);
            input.SetPersonTemplate(template);
        }

        protected override async Task Lookup(string index)
        {
            if (!int.TryParse(index, out var personIndex))
            {
                Log("Please enter a valid Entity Index to copy from.");
                return;
            }

            var person = await apiService.GetEntityPerson(personIndex);
            var model = Clone(person.AsObjectLite());
            var template = templateService.GetTemplate(TemplateId.EntityPerson, model);
            input.SetPersonTemplate(template);
        }

        /// <summary>
        /// Generates Entity Person list.
        /// </summary>
        protected async override Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var persons = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);

                for (var i = 0; i < persons.Length; i++)
                {
                    persons[i] = Generate(parameters.Person, CreateFormatter(suffix.Increment()));
                }

                await apiService.Create<DTO.EntityCreateResponse>(
                    apiService.CreateDataRequest<DTO.EntityCreateRequest>("entity/person", persons));

                Log($"Total {parameters.NumToCreate} Person(s) successfully created.");
            }
        }
    }
}
