﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace SampleApp.Views
{
    public partial class MainView : UserControl, IView, ILog
    {
        private IViewController viewController;

        public MainView(IViewController viewController)
        {
            this.viewController = viewController;
            InitializeComponent();

            llClientCreate.Links[0].LinkData = ViewCodes.Client;
            llMatterCreate.Links[0].LinkData = ViewCodes.Matter;
            llTimekeeperCreate.Links[0].LinkData = ViewCodes.Timekeeper;
            llEntityOrgCreate.Links[0].LinkData = ViewCodes.EntityOrg;
            llEntityPersonCreate.Links[0].LinkData = ViewCodes.EntityPerson;
            llTimecardCreate.Links[0].LinkData = ViewCodes.Timecard;
            llCostcardCreate.Links[0].LinkData = ViewCodes.Costcard;
            llCostcardPending.Links[0].LinkData = ViewCodes.CostcardPending;
            llTimecardPending.Links[0].LinkData = ViewCodes.TimecardPending;
            llVoucher.Links[0].LinkData = ViewCodes.Voucher;
            llChargeCard.Links[0].LinkData = ViewCodes.ChargeCard;
            llChargeCardPending.Links[0].LinkData = ViewCodes.ChargeCardPending;
            llPayee.Links[0].LinkData = ViewCodes.Payee;
            llVendorPayee.Links[0].LinkData = ViewCodes.VendorPayee;
            llDirectCheck.Links[0].LinkData = ViewCodes.DirectCheck;
        }

        public string Caption => "Main";

        public string ApiUrl
        {
            get
            {
                return textUrl.Text;
            }
            set
            {
                textUrl.Text = value;
            }
        }

        public void UpdateState(bool enabled)
        {
            llClientCreate.Enabled = enabled;
            llMatterCreate.Enabled = enabled;
            llTimekeeperCreate.Enabled = enabled;
            llEntityOrgCreate.Enabled = enabled;
            llEntityPersonCreate.Enabled = enabled;
            llTimecardCreate.Enabled = enabled;
            llCostcardCreate.Enabled = enabled;
            llCostcardPending.Enabled = enabled;
            llTimecardPending.Enabled = enabled;
            llVoucher.Enabled = enabled;
            llChargeCard.Enabled = enabled;
            llChargeCardPending.Enabled = enabled;
            llPayee.Enabled = enabled;
            llVendorPayee.Enabled = enabled;
            llDirectCheck.Enabled = enabled;

        }

        public void Log(string message)
        {
            if (!string.IsNullOrEmpty(message))
            {
                textLog.AppendText(message);
                textLog.AppendText(Environment.NewLine);
            }
        }

        private void Command_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                viewController.Attach((string)e.Link.LinkData);
            }
            catch (Exception ex)
            {
                Log(ex.Message);
            }
        }
    }
}
