﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;

    public class PayeeView : CaseBaseView
    {
        PayeeInput input;

        public PayeeView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Payee Index");
            this.input = new PayeeInput(this, this.objectService, this.cacheService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "Payee";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.Payee);
            input.SetPayeeTemplate(template);
        }

        protected async override Task Lookup(string index)
        {
            if (!int.TryParse(index, out var payeeIndex) || payeeIndex <= 0)
            {
                Log("Please enter a valid Payee Index to copy from.");
                return;
            }

            var payee = await apiService.GetPayee(payeeIndex);
            var model = Clone(payee);
            var template = templateService.GetTemplate(TemplateId.Payee, model);
            input.SetPayeeTemplate(template);
        }

        /// <summary>
        /// Generates Payee list.
        /// </summary>
        protected override async Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var payee = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);

                for (var i = 0; i < payee.Length; i++)
                {
                    var date = parameters.StartDate.AddDays(i / parameters.PayeePerDay).ToString("yyyy-MM-dd");
                    payee[i] = Generate(parameters.Payee, CreateFormatter(suffix.Increment(), date));
                }

                await apiService.Create<DTO.PayeeCreateResponse>(
                apiService.CreateGenericDataRequest("dataobject", payee, payee[0].SubclassId, "PayeeMnt"));

                Log($"Total {parameters.NumToCreate} Payee(s) successfully created.");
            }
        }
    }
}
