﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.DTO;
    using SampleApp.Services;

    public class VoucherView : CaseBaseView
    {
        VoucherInput input;

        public VoucherView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("Voucher Index");
            this.input = new VoucherInput(this, this.objectService, this.cacheService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "Voucher";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.Voucher);
            input.SetTimecardTemplate(template);
        }

        protected async override Task Lookup(string index)
        {
            if (!int.TryParse(index, out var VoucherIndex) || VoucherIndex <= 0)
            {
                Log("Please enter a valid Voucher Index to copy from.");
                return;
            }

            var voucher = await apiService.GetVoucher(VoucherIndex);
            var model = Clone(voucher);
            var template = templateService.GetTemplate(TemplateId.Voucher, model);
            input.SetTimecardTemplate(template);
        }

        /// <summary>
        /// Generates Timecard list.
        /// </summary>
        protected override async Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var voucher = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);
                string key = "";
                for (var i = 0; i < voucher.Length; i++)
                {
                    var date = parameters.StartDate.AddDays(i / parameters.VoucherPerDay).ToString("yyyy-MM-dd");
                    voucher[i] = Generate(parameters.Voucher, CreateFormatter(suffix.Increment(), date));
                    var value = voucher[i].Attributes;
                   
                    foreach(var item in value)
                    {
                        if (item.Key == "VchrIndex")
                        {
                            key = item.Value.Value.ToString();
                            break;
                        }
                    }
                }

                await apiService.Create<DTO.VoucherCreateResponse>(
                apiService.CreateGenericDataRequest("dataobject", voucher, voucher[0].SubclassId, voucher[0].SubclassId));

                Log($"Total {parameters.NumToCreate} Voucher(s) successfully created.");
            }
        }
    }
}
