﻿namespace SampleApp.Views
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using RestSharp;
    using SampleApp.Controls;
    using SampleApp.Services;

    public class DirectChecksView : CaseBaseView
    {
        DirectCheckInput input;

        public DirectChecksView(IRestClient client, AuthenticationService authService)
            : base(client, authService)
        {
            this.SetLookupName("DirectCheck Index");
            this.input = new DirectCheckInput(this, this.objectService, this.cacheService);
            this.AddInput(input);
            this.Reset();
        }

        public override string Caption => "DirectCheck";

        protected override void Reset()
        {
            var template = templateService.GetTemplate(TemplateId.DirectCheck);
            input.SetDirectChecksTemplate(template);
        }

        protected async override Task Lookup(string index)
        {
            if (!int.TryParse(index, out var DirectCheckIndex) || DirectCheckIndex <= 0)
            {
                Log("Please enter a valid DirectCheckIndex Index to copy from.");
                return;
            }

            var DirectCheck = await apiService.GetDirectCheck(DirectCheckIndex);
            var model = Clone(DirectCheck);
            var template = templateService.GetTemplate(TemplateId.DirectCheck, model);
            input.SetDirectChecksTemplate(template);
        }

        /// <summary>
        /// Generates DirectChecks list.
        /// </summary>
        protected override async Task Execute()
        {
            if (input.TryGetParameters(out var parameters))
            {
                var directcheck = new DTO.DataObjectLite[parameters.NumToCreate];
                var suffix = new Suffix(parameters.SuffixStart, parameters.SuffixFormat);

                for (var i = 0; i < directcheck.Length; i++)
                {
                    var date = parameters.StartDate.AddDays(i / parameters.DirectCheckPerDay).ToString("yyyy-MM-dd");
                    directcheck[i] = Generate(parameters.DirectCheck, CreateFormatter(suffix.Increment(), date));
                }

                await apiService.Create<DTO.DirectCheckCreateResponse>(
                apiService.CreateGenericDataRequest("dataobject", directcheck, "CkDirect", "DirectCk"));

                Log($"Total {parameters.NumToCreate} DirectCheck(s) successfully created.");
            }
        }
    }
}
